/*
 * Call initialization routines for all libfma pieces that need it
 */
#include <stdio.h>

#include "libfma.h"
#include "lf_scheduler.h"
#include "lf_alert.h"

void
lf_init()
{
  int rc;

  lf_scheduler_init();
  lf_socket_init();

  rc = lf_init_alert();
  if (rc == -1) {
    perror("Error initializing alerts in libfma");
    exit(1);
  }
}

void
lf_finalize()
{
  lf_scheduler_finalize();
  lf_socket_finalize();
}
